/*
 * Decompiled with CFR 0.152.
 */
package com.kakarote.update.utils;

import cn.hutool.core.util.RandomUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.db.Db;
import cn.hutool.db.Entity;
import cn.hutool.db.ds.simple.SimpleDataSource;
import cn.hutool.db.transaction.TransactionLevel;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;

public class UpdateService {
    private final int oa_num = 1000000;

    public void update() throws Exception {
        Db db = this.createDb();
        if (db == null) {
            return;
        }
        db.tx(TransactionLevel.READ_UNCOMMITTED, conn -> {
            this.saveFlow((Db)conn);
            this.saveFlowOptional((Db)conn);
            this.saveOaFlow((Db)conn);
            this.saveOaFlowOptional((Db)conn);
            conn.execute("INSERT INTO wk_examine_manager_user\nSELECT NULL AS id,a.examine_id,'14773' as user_id,'0' AS sort FROM wk_examine AS a", new Object[0]);
            this.saveRecord((Db)conn);
        });
    }

    private Db createDb() {
        System.out.println("\u8bf7\u5148\u8f93\u5165\u6570\u636e\u5e93\u4fe1\u606f");
        System.out.println("\u6570\u636e\u5e93\u8fde\u63a5\u5730\u5740\uff1a\u4f8b 127.0.0.1");
        Scanner input = new Scanner(System.in);
        String ip = input.next();
        System.out.println("\u8bf7\u8f93\u5165\u6570\u636e\u5e93\u7aef\u53e3");
        int port = input.nextInt();
        System.out.println("\u8bf7\u8f93\u5165\u6570\u636e\u5e93\u540d\uff1a\u4f8b wk_crm_single");
        String datasource = input.next();
        System.out.println("\u7528\u6237\u540d\uff1a\u4f8b root");
        String username = input.next();
        System.out.println("\u5bc6\u7801\uff1a\u4f8b password");
        String password = input.next();
        try {
            String dataUrl = "jdbc:mysql://" + ip + ":" + port + "/" + datasource + "?characterEncoding=utf8&serverTimezone=Asia/Shanghai";
            SimpleDataSource dataSource = new SimpleDataSource(dataUrl, username, password);
            return Db.use(dataSource);
        }
        catch (Exception e) {
            System.out.println("\u6570\u636e\u5e93\u8fde\u63a5\u5931\u8d25\uff01");
            e.printStackTrace();
            return null;
        }
    }

    private void saveFlow(Db conn) throws SQLException {
        conn.execute("INSERT INTO wk_examine\nSELECT examine_id,category_type AS label,icon AS examine_icon,NAME AS examine_name,'1' AS recheck_type,create_time,create_user_id,(CASE STATUS WHEN 1 THEN 1 WHEN 0 THEN 2 WHEN 2 THEN 3 ELSE 1 END) AS STATUS,uuid() AS batch_id,remarks,update_time,update_user_id,NULL AS user_ids,NULL AS dept_ids,'0' AS oa_type FROM wk_crm_examine", new Object[0]);
        conn.execute("UPDATE wk_examine SET batch_id = REPLACE ( batch_id, '-', '' )", new Object[0]);
        conn.execute("UPDATE wk_examine SET `status` = '2'", new Object[0]);
        conn.execute("UPDATE wk_examine SET `status`='1' WHERE examine_id IN (SELECT max(examine_id) FROM wk_crm_examine WHERE `status`='1' GROUP BY category_type)", new Object[0]);
        Map<Integer, String> batchIdMap = conn.find(new Entity().setTableName("wk_examine").setFieldNames("examine_id", "batch_id")).stream().collect(Collectors.toMap(k -> k.getInt("examine_id"), v -> v.getStr("batch_id")));
        List<Entity> entityList = conn.findAll("wk_crm_examine_step");
        for (Entity entity : entityList) {
            Integer stepType = entity.getInt("step_type");
            switch (stepType) {
                case 1: {
                    Entity flowSuperior = new Entity();
                    flowSuperior.setTableName("wk_examine_flow_superior");
                    flowSuperior.set("flow_id", entity.getInt("step_id"));
                    flowSuperior.set("parent_level", 1);
                    flowSuperior.set("type", 1);
                    flowSuperior.set("batch_id", batchIdMap.get(entity.getInt("examine_id")));
                    conn.insert(flowSuperior);
                    break;
                }
                case 2: {
                    List<String> userIds = StrUtil.splitTrim((CharSequence)entity.getStr("check_user_id"), ",");
                    Entity flowMember = new Entity();
                    flowMember.setTableName("wk_examine_flow_member");
                    flowMember.set("flow_id", entity.getInt("step_id"));
                    flowMember.set("user_id", userIds.get(0));
                    flowMember.set("type", 1);
                    flowMember.set("batch_id", batchIdMap.get(entity.getInt("examine_id")));
                    conn.insert(flowMember);
                    break;
                }
                case 3: {
                    List<String> userIds = StrUtil.splitTrim((CharSequence)entity.getStr("check_user_id"), ",");
                    for (String userId : userIds) {
                        Entity flowMember = new Entity();
                        flowMember.setTableName("wk_examine_flow_member");
                        flowMember.set("flow_id", entity.getInt("step_id"));
                        flowMember.set("user_id", userId);
                        flowMember.set("type", 1);
                        flowMember.set("batch_id", batchIdMap.get(entity.getInt("examine_id")));
                        conn.insert(flowMember);
                    }
                    break;
                }
                case 4: {
                    Entity flowSuperior = new Entity();
                    flowSuperior.setTableName("wk_examine_flow_superior");
                    flowSuperior.set("flow_id", entity.getInt("step_id"));
                    flowSuperior.set("parent_level", 2);
                    flowSuperior.set("type", 1);
                    flowSuperior.set("batch_id", batchIdMap.get(entity.getInt("examine_id")));
                    conn.insert(flowSuperior);
                }
            }
            Entity examineFlow = new Entity();
            examineFlow.setTableName("wk_examine_flow");
            examineFlow.set("flow_id", entity.getInt("step_id"));
            examineFlow.set("name", "\u4e1a\u52a1\u5ba1\u6279" + RandomUtil.randomInt(1000, 9999));
            examineFlow.set("examine_id", entity.getInt("examine_id"));
            examineFlow.set("examine_type", Arrays.asList(2, 3).contains(stepType) ? 1 : 2);
            examineFlow.set("examine_error_handling", 2);
            examineFlow.set("condition_id", 0);
            examineFlow.set("sort", entity.getInt("step_num"));
            examineFlow.set("create_time", entity.getDate("create_time"));
            examineFlow.set("create_user_id", 0L);
            examineFlow.set("batch_id", batchIdMap.get(entity.getInt("examine_id")));
            conn.insert(examineFlow);
        }
    }

    private void saveOaFlow(Db conn) throws SQLException {
        conn.execute("INSERT INTO wk_examine\nSELECT (category_id+1000000) AS examine_id,'0' AS label,icon AS examine_icon,title AS examine_name,'1' AS recheck_type,create_time,create_user_id,(CASE STATUS WHEN 1 THEN 1 WHEN 0 THEN 2 WHEN 2 THEN 3 ELSE 1 END) AS STATUS,uuid() AS batch_id,remarks,update_time,create_user_id,user_ids AS user_ids,dept_ids AS dept_ids,type AS oa_type FROM wk_oa_examine_category", new Object[0]);
        conn.execute("UPDATE wk_examine SET batch_id = REPLACE ( batch_id, '-', '' )", new Object[0]);
        Map<Integer, String> batchIdMap = conn.find(new Entity().setTableName("wk_examine").setFieldNames("examine_id", "batch_id")).stream().collect(Collectors.toMap(k -> k.getInt("examine_id"), v -> v.getStr("batch_id")));
        List<Entity> entityList = conn.findAll("wk_oa_examine_step");
        for (Entity entity : entityList) {
            Integer stepType = entity.getInt("step_type");
            switch (stepType) {
                case 1: {
                    Entity flowSuperior = new Entity();
                    flowSuperior.setTableName("wk_examine_flow_superior");
                    flowSuperior.set("flow_id", entity.getInt("step_id") + 1000000);
                    flowSuperior.set("parent_level", 1);
                    flowSuperior.set("type", 1);
                    flowSuperior.set("batch_id", batchIdMap.get(entity.getInt("category_id") + 1000000));
                    conn.insert(flowSuperior);
                    break;
                }
                case 2: {
                    List<String> userIds = StrUtil.splitTrim((CharSequence)entity.getStr("check_user_id"), ",");
                    Entity flowMember = new Entity();
                    flowMember.setTableName("wk_examine_flow_member");
                    flowMember.set("flow_id", entity.getInt("step_id") + 1000000);
                    flowMember.set("user_id", userIds.get(0));
                    flowMember.set("type", 1);
                    flowMember.set("batch_id", batchIdMap.get(entity.getInt("category_id") + 1000000));
                    conn.insert(flowMember);
                    break;
                }
                case 3: {
                    List<String> userIds = StrUtil.splitTrim((CharSequence)entity.getStr("check_user_id"), ",");
                    for (String userId : userIds) {
                        Entity flowMember = new Entity();
                        flowMember.setTableName("wk_examine_flow_member");
                        flowMember.set("flow_id", entity.getInt("step_id") + 1000000);
                        flowMember.set("user_id", userId);
                        flowMember.set("type", 1);
                        flowMember.set("batch_id", batchIdMap.get(entity.getInt("category_id") + 1000000));
                        conn.insert(flowMember);
                    }
                    break;
                }
                case 4: {
                    Entity flowSuperior = new Entity();
                    flowSuperior.setTableName("wk_examine_flow_superior");
                    flowSuperior.set("flow_id", entity.getInt("step_id") + 1000000);
                    flowSuperior.set("parent_level", 2);
                    flowSuperior.set("type", 1);
                    flowSuperior.set("batch_id", batchIdMap.get(entity.getInt("category_id") + 1000000));
                    conn.insert(flowSuperior);
                }
            }
            Entity examineFlow = new Entity();
            examineFlow.setTableName("wk_examine_flow");
            examineFlow.set("flow_id", entity.getInt("step_id") + 1000000);
            examineFlow.set("name", "\u4e1a\u52a1\u5ba1\u6279" + RandomUtil.randomInt(1000, 9999));
            examineFlow.set("examine_id", entity.getInt("category_id") + 1000000);
            examineFlow.set("examine_type", Arrays.asList(2, 3).contains(stepType) ? 1 : 2);
            examineFlow.set("examine_error_handling", 2);
            examineFlow.set("condition_id", 0);
            examineFlow.set("sort", entity.getInt("step_num"));
            examineFlow.set("create_time", entity.getDate("create_time"));
            examineFlow.set("create_user_id", 0L);
            examineFlow.set("batch_id", batchIdMap.get(entity.getInt("category_id") + 1000000));
            conn.insert(examineFlow);
        }
    }

    private void saveOaFlowOptional(Db conn) throws SQLException {
        List<Entity> entityList = conn.query("SELECT a.*,b.batch_id FROM wk_oa_examine_category as a JOIN wk_examine as b on a.category_id + 1000000 = b.examine_id WHERE a.examine_type ='2' and a.is_deleted='0'", new Object[0]);
        ArrayList<Entity> examineFlowList = new ArrayList<Entity>();
        for (Entity entity : entityList) {
            Entity examineFlow = new Entity();
            examineFlow.setTableName("wk_examine_flow");
            examineFlow.set("name", "\u529e\u516c\u5ba1\u6279" + RandomUtil.randomInt(1000, 9999));
            examineFlow.set("examine_id", entity.getInt("category_id") + 1000000);
            examineFlow.set("examine_type", 4);
            examineFlow.set("examine_error_handling", 2);
            examineFlow.set("condition_id", 0);
            examineFlow.set("sort", 1);
            examineFlow.set("create_time", entity.getDate("create_time"));
            examineFlow.set("create_user_id", entity.getLong("create_user_id"));
            examineFlow.set("batch_id", entity.getStr("batch_id"));
            examineFlowList.add(examineFlow);
        }
        conn.insert(examineFlowList);
        conn.execute("INSERT INTO wk_examine_flow_optional\nSELECT NULL AS id,flow_id,NULL AS user_id,NULL AS role_id,'2' AS choose_type,'1' AS type,'0' AS sort,batch_id,'1' AS range_type FROM wk_examine_flow WHERE examine_type='4'", new Object[0]);
        conn.execute("update wk_oa_examine set category_id = category_id + 1000000", new Object[0]);
        conn.execute("update wk_oa_examine_field set examine_category_id = examine_category_id + 1000000", new Object[0]);
        conn.execute("update wk_oa_examine_sort set category_id = category_id + 1000000", new Object[0]);
    }

    private void saveFlowOptional(Db conn) throws SQLException {
        List<Entity> entityList = conn.query("SELECT a.*,b.batch_id FROM wk_crm_examine as a JOIN wk_examine as b on a.examine_id = b.examine_id WHERE a.examine_type ='2'", new Object[0]);
        ArrayList<Entity> examineFlowList = new ArrayList<Entity>(entityList.size());
        ThreadLocalRandom random = RandomUtil.getRandom();
        for (Entity entity : entityList) {
            Entity examineFlow = new Entity();
            examineFlow.setTableName("wk_examine_flow");
            examineFlow.set("name", "\u4e1a\u52a1\u5ba1\u6279" + random.nextInt(1000, 9999));
            examineFlow.set("examine_id", entity.getInt("examine_id"));
            examineFlow.set("examine_type", 4);
            examineFlow.set("examine_error_handling", 2);
            examineFlow.set("condition_id", 0);
            examineFlow.set("sort", 1);
            examineFlow.set("create_time", entity.getDate("create_time"));
            examineFlow.set("create_user_id", entity.getLong("create_user_id"));
            examineFlow.set("batch_id", entity.getStr("batch_id"));
            examineFlowList.add(examineFlow);
        }
        conn.insert(examineFlowList);
        conn.execute("INSERT INTO wk_examine_flow_optional\nSELECT NULL AS id,flow_id,NULL AS user_id,NULL AS role_id,'2' AS choose_type,'1' AS type,'0' AS sort,batch_id,'1' AS range_type FROM wk_examine_flow WHERE examine_type='4'", new Object[0]);
    }

    private void saveRecord(Db conn) throws SQLException {
        conn.execute("INSERT INTO wk_examine_record\nSELECT a.record_id,a.examine_id,b.category_type AS label,IFNULL(a.examine_step_id,0) AS flow_id,NULL AS type_id,a.examine_status,a.create_time,a.create_user AS create_user_id,now() AS update_time,a.create_user AS update_user_id FROM wk_crm_examine_record AS a JOIN wk_crm_examine AS b ON a.examine_id=b.examine_id", new Object[0]);
        conn.execute("INSERT INTO wk_examine_record_log\nSELECT a.log_id,b.examine_id,IFNULL(a.examine_step_id,0) AS flow_id,a.record_id,'1' AS type,order_id AS sort,a.examine_status,a.examine_user AS examine_user_id,'0' AS examine_role_id,a.create_user AS create_user_id,a.create_time,now() AS update_time,MD5(a.record_id) AS batch_id,a.remarks FROM wk_crm_examine_log AS a JOIN wk_crm_examine_record AS b ON a.record_id=b.record_id", new Object[0]);
        conn.execute("INSERT INTO wk_examine_record \nSELECT\na.record_id + 1000000 as record_id,\nb.category_id + 1000000 as examine_id,\n'0' AS label,\n(\ncase \nWHEN IFNULL( a.examine_step_id, 0) > 0 THEN a.examine_step_id + 1000000\nELSE 0 END) AS flow_id,\na.examine_id AS type_id,\na.examine_status,\na.create_time,\na.create_user AS create_user_id,\nnow() AS update_time,\na.create_user AS update_user_id\nFROM\n\twk_oa_examine_record AS a\n\tJOIN wk_oa_examine as b on a.examine_id = b.examine_id", new Object[0]);
        conn.execute("UPDATE wk_oa_examine as a INNER JOIN wk_examine_record as b ON a.examine_id = b.type_id and b.label='0'\n   SET a.examine_record_id = b.record_id,a.examine_status=b.examine_status", new Object[0]);
        conn.execute("INSERT INTO wk_examine_record_log \nSELECT\na.log_id + 1000000 as log_id,\nc.category_id as examine_id,\n(case WHEN IFNULL( a.examine_step_id, 0) > 0 THEN a.examine_step_id+1000000 ELSE 0 END) AS flow_id,\na.record_id + 1000000 as record_id,\n'1' AS type,\norder_id AS sort,\na.examine_status,\na.examine_user AS examine_user_id,\n'0' AS examine_role_id,\na.create_user AS create_user_id,\na.create_time,\nnow() AS update_time,\nMD5( a.record_id+1000000 ) AS batch_id,\na.remarks \nFROM\n\twk_oa_examine_log AS a\n\tJOIN wk_oa_examine_record AS b ON a.record_id = b.record_id\tJOIN wk_oa_examine as c on b.examine_id = c.examine_id", new Object[0]);
        conn.execute("INSERT INTO wk_examine_record_log\nSELECT NULL AS log_id,examine_id,flow_id,record_id,'1' AS type,'0' AS sort,'6' AS examine_status,'0' AS examine_user_id,'0' AS examine_role_id,create_user_id,create_time,update_time,md5(record_id) AS batch_id,'' AS remarks FROM wk_examine_record AS a", new Object[0]);
        conn.execute("UPDATE wk_examine_record as a INNER JOIN wk_crm_contract as b on a.record_id = b.examine_record_id and a.label='1'\nSET a.type_id = b.contract_id", new Object[0]);
        conn.execute("UPDATE wk_examine_record as a INNER JOIN wk_crm_invoice as b on a.record_id = b.examine_record_id and a.label='3'\nSET a.type_id = b.invoice_id", new Object[0]);
    }
}

